#!/bin/bash

# запретить прерывание скрипта
trap '' 1 2 3 6 15
echo heartbeat >/sys/class/leds/uc811x:DIA1/trigger

# чтение конфигурационных файлов для возможности их отредактировать
cp /etc/network/interfaces /media/INTERFACE/MOXA/INFO
cp /etc/sysctl.conf /media/INTERFACE/MOXA/INFO
cp /etc/hostname /media/INTERFACE/MOXA/INFO
cp /etc/hosts /media/INTERFACE/MOXA/INFO

# текущая информация по сети
ifconfig >/media/INTERFACE/MOXA/INFO/ifconfig.log

# текущая информация по времени
timedatectl >/media/INTERFACE/MOXA/INFO/time_date.log

# создание архива сервера (требуется остановка для доступа к файлам)
/opt/InterfaceSSH/server/ifpcore_lx_arm7_32 -SSTOP
tar -czvf /media/INTERFACE/MOXA/INFO/oik_copy.tar.gz /opt/InterfaceSSH/server/PortCore /var/lib/Ifpcore
/opt/InterfaceSSH/server/ifpcore_lx_arm7_32 -SSTART

sync # flush buffers
sleep 2
echo none >/sys/class/leds/uc811x:DIA1/trigger
echo 0 >/sys/class/leds/uc811x:DIA1/brightness
sleep 1
echo 0 >/sys/class/leds/uc811x:USB/brightness

