#!/bin/bash

if [[ $(id -u) -ne 0 ]]
  then echo "Ошибка: скрипт должен исполняться с правами root!"
  exit
fi

echo "Установка и настройка Docker и контейнеров базы данных ОИК Диспетчер НТ"
echo
wait

LIN_DISTRO=$(cat /etc/*-release | awk -F"\"" '/PRETTY_NAME=/{print $2}' | awk '{print tolower($1)}')

if [[ (${LIN_DISTRO} != "alt") ]]
then
    apt-get update
    apt-get -y install apt-transport-https ca-certificates curl gnupg2 software-properties-common
    curl -fsSL https://download.docker.com/linux/${LIN_DISTRO}/gpg | apt-key add -
    add-apt-repository \
		"deb [arch=amd64] https://download.docker.com/linux/${LIN_DISTRO} \
		$(lsb_release -cs) \
		stable"
    
fi

apt-get update
apt-get -y install docker-ce

if [[ ${LIN_DISTRO} = "alt" ]]
then
    systemctl enable --now docker
fi

if [[ ! $(docker volume ls -q -f name=oik_postgres_storage) ]]
then
    docker volume create oik_postgres_storage
fi

if [[ ! $(docker network ls -q -f name=oik-net) ]]
then
    docker network create --driver bridge --subnet 192.168.3.0/24 oik-net
fi

TIMEZONE=$(cat /etc/timezone)
KEY=$(ls -l /sys/class/hidraw/ | grep FACE | awk -F "hidraw/" '{print $2}')

docker run -d \
           --name ifpcore \
           --network host \
           --mount type=volume,source=ifpcore_storage,target=/var/lib/postgresql/data \
           --env POSTGRES_PASSWORD=postgres \
           --env TZ=$TIMEZONE \
           --restart unless-stopped \
           --device /dev/$KEY \
           ifaceru/ifpcore

chmod 644 setup.sh
chmod 744 start-ifpcore.sh
chmod 744 stop-ifpcore.sh

echo "Готово!" 