CREATE TABLE oik.oik_map_v2
(
    center_latitude  double precision NOT NULL,
    center_longitude double precision NOT NULL,
    zoom             integer          NOT NULL,
    zoom_min         integer          NOT NULL,
    zoom_max         integer          NOT NULL,
    tile_url_format  text             NOT NULL
);

ALTER TABLE oik.oik_map_v2
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_map_v2 TO oik_group_super;
GRANT ALL ON TABLE oik.oik_map_v2 TO postgres;

INSERT INTO oik.oik_map_v2 
(center_latitude, center_longitude, zoom, zoom_min, zoom_max, tile_url_format) 
VALUES 
(56.823301, 60.552310, 12, 9, 18, 'https://{prefix}.tile.openstreetmap.org/{zoom}/{x}/{y}.png');





CREATE TABLE oik.oik_map_v2_placemarks
(
    id            uuid NOT NULL
        CONSTRAINT oik_map_v2_placemarks_pk
            PRIMARY KEY,
    name          text,
    description   text,
    geometry      xml,
    extended_data xml
);

ALTER TABLE oik.oik_map_v2_placemarks
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_map_v2_placemarks TO oik_group_super;
GRANT ALL ON TABLE oik.oik_map_v2_placemarks TO postgres;