-- FOREIGN TABLE: oik.oik_microseries
-- DROP FOREIGN TABLE oik.oik_microseries;

CREATE FOREIGN TABLE IF NOT EXISTS oik.oik_microseries(
  idx           smallint  OPTIONS(field_id '1101'),
  intv          smallint  OPTIONS(field_id '1102'),
  vtime         timestamp OPTIONS(field_id '1103'),
  val           real      OPTIONS(field_id '1104'),
  sflg          smallint  OPTIONS(field_id '1105'),

  tma                 int       OPTIONS(field_id '4'),
  tma_str             varchar(20) OPTIONS(field_id '10001'),
  ch                  smallint  OPTIONS(field_id '5'),
  rtu                 smallint  OPTIONS(field_id '6'),
  point               smallint  OPTIONS(field_id '7')
)
    SERVER oik_server
    OPTIONS (table_id '16');

ALTER FOREIGN TABLE oik.oik_microseries
    OWNER TO postgres;



-- View: oik.v_microseries
-- DROP VIEW oik.v_microseries;

CREATE OR REPLACE VIEW v_microseries      AS SELECT * FROM oik.oik_microseries;

ALTER TABLE oik.v_microseries
    OWNER TO postgres;

GRANT ALL ON TABLE oik.v_microseries TO postgres;
GRANT SELECT ON TABLE oik.v_microseries TO oik_group_super;



---------------------------
-- GROUP oik_group_super --
---------------------------
GRANT ALL ON SCHEMA oik TO oik_group_super;
GRANT SELECT ON ALL TABLES IN SCHEMA oik TO oik_group_super;

---------------------------
-- GROUP oik_group_public --
---------------------------
GRANT USAGE ON SCHEMA oik TO oik_group_public;

