window.GetElementHeight = function (id) {
    const element = document.getElementById(id);

    if (!element) {
        return 0;
    }

    return element.getBoundingClientRect().height;
}

window.GetElementWidth = function (id) {
    const element = document.getElementById(id);

    if (!element) {
        return 0;
    }

    return element.getBoundingClientRect().width;
}

window.SetElementWidth = function (id, newValue) {
    const element = document.getElementById(id);

    if (!element) {
        return;
    }

    element.setAttribute("style", "width:" + newValue + "px");
}

window.GetGridRowAvgHeight = function (id) {
    const gridElement = document.getElementById(id);
    if (!gridElement) {
        return 0;
    }

    const rows = [...gridElement.getElementsByClassName("k-master-row")];

    if (rows.length <= 0) {
        return -1;
    }

    return rows.reduce((acc, row) => acc + row.getBoundingClientRect().height, 0) / rows.length;
}

window.GetGridContainerHeight = function (id) {
    const gridElement = document.getElementById(id);
    if (!gridElement) {
        return 0;
    }

    const items = [...gridElement.getElementsByClassName("k-grid-container")];

    if (items.length <= 0) {
        return -1;
    }

    return items[0].getBoundingClientRect().height;
}

window.GetGridPagerHeight = function (id) {
    const gridElement = document.getElementById(id);
    if (!gridElement) {
        return 0;
    }

    const items = [...gridElement.getElementsByClassName("k-grid-pager")];

    if (items.length <= 0) {
        return -1;
    }

    return items[0].getBoundingClientRect().height;
}

window.CalculateGridPageSize = function (id) {
    let freeSpace = window.GetGridContainerHeight(id) - window.GetGridPagerHeight(id);
    let rowAvgHeight = window.GetGridRowAvgHeight(id);

    if (freeSpace <= 0 || rowAvgHeight < 1) {
        return 0;
    }

    return Math.floor(freeSpace / rowAvgHeight);
}

window.ScrollIntoView = function (id) {
    const element = document.getElementById(id);

    if (!element) {
        return 0;
    }

    element.scrollIntoView();
}

window.TriggerFileDownload = function (fileName, url) {
    const anchorElement = document.createElement('a');
    anchorElement.href = url;
    anchorElement.download = fileName ?? '';
    anchorElement.click();
    anchorElement.remove();
}

window.SpellcheckOff = function () {
    document.querySelectorAll('input, textarea').forEach(field => field.spellcheck = false)
}

window.SetAbsolutesRelativeLeftPosition = function (baseId, absoluteId, offset = 0) {
    const parentElement = document.getElementById(baseId);
    const absoluteElement = document.getElementById(absoluteId);

    if (!parentElement || !absoluteElement) {
        return 0;
    }

    const parentWidth = parentElement.offsetWidth;

    absoluteElement.style.left = (parentWidth + offset) + "px";
}

window.IsOutOfBounds = function (id) {
    const element = document.getElementById(id);
    const rect = element.getBoundingClientRect();

    let parent = element.offsetParent;
    let bottom = 0;

    while (parent != null) {
        const parentRect = parent.getBoundingClientRect();

        if (parentRect.bottom > bottom) {
            bottom = parentRect.bottom;
        }

        parent = parent.offsetParent;
    }


    return rect.bottom > bottom;
}

window.Blur = function () {
    document.activeElement.blur();
}

window.PreventNonNumericInput = function (id, remove = false) {

    const keydownHandler = function (e) {

        if (e.ctrlKey
            || (47 < e.keyCode && e.keyCode < 58 && e.shiftKey === false)
            || (95 < e.keyCode && e.keyCode < 106 && e.altKey === false)
            || (e.keyCode === 8) || (e.keyCode === 9)
            || (e.keyCode > 34 && e.keyCode < 40)
            || (e.keyCode === 46)) {
            return;
        }
        e.preventDefault();
    }


    const input = document.getElementById(id);

    if (input === null) {
        return;
    }

    if (remove) {
        input.removeEventListener('keydown', keydownHandler);
        return;
    }

    input.addEventListener('keydown', keydownHandler);
}

window.GetBrowserDimensions = function () {
    return {
        height: window.screen.height,
        width: window.screen.width
    };
}