// localization
window.GetBrowserLanguage = function ()
{
  return (navigator.languages && navigator.languages.length) ? navigator.languages[0] :
         navigator.userLanguage || navigator.language || navigator.browserLanguage || 'en';
}

window.SetCulture = function (cultureName)
{
  if (!cultureName)
  {
    return;
  }
  
  const script = document.createElement('script');
  script.setAttribute('src', 'assets/scripts/telerik-reportviewer.' + cultureName + '.js');
  document.body.appendChild(script);
}

window.SetKendoCulture = function (cultureName) {
  kendo.culture(cultureName);
}

// nav-menu
window.ToggleNavPanel = function (isVisible)
{
  const navElement = document.getElementById('nav-panel');
  if (isVisible)
  {
    navElement.classList.add('flex');
    navElement.classList.remove('hidden');
  }
  else
  {
    navElement.classList.add('hidden');
    navElement.classList.remove('flex');
  }
}


// sound-player
window.PlayAudioFile = (soundName) =>
{
  if (!soundName)
  {
    return;
  }
  let sound  = document.createElement('audio');
  sound.src  = `assets/sounds/${soundName}.mp3`;
  sound.type = 'audio/mpeg';
  document.body.appendChild(sound);
  sound.load();

  sound.play().catch(() =>
                     {
                       sound.remove();
                     });

  sound.onended = _ =>
  {
    sound.remove();
  };
}


// theme-util
function findTelerikLightCssFile()
{
  for (let idx in document.styleSheets)
  {
    const cssFile = document.styleSheets[idx];
    if (cssFile.href && cssFile.href.includes('kendo-theme-material.css'))
    {
      return cssFile;
    }
  }
  return '';
}

window.SetTheme = function (themeId, isLightSubset)
{
  document.documentElement.dataset.theme = themeId;

  const telerikLightCssFile = findTelerikLightCssFile();
  if (telerikLightCssFile)
  {
    telerikLightCssFile.disabled = !isLightSubset;
  }
}


// clipboard-tool
window.CopyToClipboard = async function (text)
{
  if (navigator.clipboard && window.isSecureContext)
  {
    await navigator.clipboard.writeText(text);
  }
  else
  {
    const textArea = document.createElement("textarea");
    textArea.value = text;

    textArea.style.position = "absolute";
    textArea.style.left     = "-999999px";

    document.body.prepend(textArea);
    textArea.select();

    try
    {
      document.execCommand('copy');
    }
    catch (error)
    {
      console.error(error);
    }
    finally
    {
      textArea.remove();
    }
  }
};

window.PasteFromClipboard = async function ()
{
  if (navigator.clipboard && window.isSecureContext)
  {
    return await navigator.clipboard.readText();
  }
  else
  {
    try
    {

      document.execCommand('paste', false);
    }
    catch (error)
    {
      console.error(error);
    }
  }
}

window.SaveContentAsFile = function (filename, base64Content)
{
  const link     = document.createElement('a');
  link.className = 'hidden';
  link.download  = filename;
  link.href      = 'data:application/octet-stream;base64,' + base64Content;
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
}

window.GetGridRowAvgHeight = function (id)
{
  const gridElement = document.getElementById(id);
  if (!gridElement)
  {
    return -1;
  }

  const rows = [...gridElement.getElementsByClassName("k-master-row")];

  if (rows.length <= 0)
  {
    return -1;
  }

  return rows.reduce((acc, row) => acc + row.getBoundingClientRect().height, 0) / rows.length;
}

// scheme
window.ToggleSchemeUnackedPhase = function (id, isPhaseOn)
{
  const scheme = document.getElementById(id);
  if (!scheme)
  {
    return;
  }
  scheme.style.opacity = (isPhaseOn) ? '.6' : '0';
}

// excel-dashboard
window.InitSpreadsheet = function (id, fileBytes)
{
  const sheetContainer$ = $("#" + id).kendoSpreadsheet();
  const sheet           = sheetContainer$.data("kendoSpreadsheet");


  const fileBlob = new Blob([new Uint8Array(fileBytes)],
                            {type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'})

  sheet.fromFile(fileBlob);
}

window.DestroySpreadsheet = function (id)
{
  const sheet$ = $("#" + id);
  kendo.destroy(sheet$);
}


// telerik-reporting
window.trvEventHandlers = {
  ready: function ()
  {
    // у Telerik проблема с полями в темной теме, принудительно добавляем им нужный класс отображения
    // таймаут нужен, т.к. эти поля почему-то не сразу появляются
    setTimeout(function ()
               {
                 document.querySelectorAll('.trv-parameter-value > .k-input')
                         .forEach(el => el.classList.add('k-input-solid'))
               },
               500);
  }
}